#include <omp.h>
#include <stdio.h>

int main() {
//    #pragma omp parallel
//    {
//        printf("Hello from thread %d\n", omp_get_thread_num());
//    }

   // Set the number of threads globally for all parallel regions
    omp_set_num_threads(3);

    // Parallel region with 3 threads (as set by omp_set_num_threads)
    #pragma omp parallel
    {
        printf("Thread with previous set %d out of %d\n", omp_get_thread_num(), omp_get_num_threads());
    }

    // Parallel region with 5 threads (overrides global setting with num_threads clause)
    #pragma omp parallel num_threads(5)
    {
        printf("Thread %d out of %d\n", omp_get_thread_num(), omp_get_num_threads());
    }


    return 0;
}
